function faq() {
    const quest = document.querySelectorAll('.faq_quests');
    const aswer = document.querySelectorAll('.aswer');
    //const img_icon = document.querySelectorAll('.img_icon');

    for (let i = 0; i < quest.length; i++) {
        quest[i].addEventListener('click', () => {
            if (quest[i].classList.contains('close')) {
                quest[i].classList.toggle('close');
                aswer[i].classList.toggle('open');
                //img_icon[i].src = 'img/set.svg';
            } else {
                quest[i].classList.add('close');
                aswer[i].classList.add('open');

                //img_icon[i].src = 'img/-.svg';
            }
        });
    }
}
faq();

function startTimer(duration, display) {
    let timer = duration;

    const updateDisplay = () => {
        const minutes = String(Math.floor(timer / 60)).padStart(2, '0');
        const seconds = String(timer % 60).padStart(2, '0');
        if (display) display.innerHTML = `${minutes}:${seconds}`;
    };

    updateDisplay(); // Atualiza imediatamente a interface antes de iniciar o intervalo

    const interval = setInterval(() => {
        if (timer > 0) {
            timer--;
            updateDisplay();
        } else {
            clearInterval(interval); // Para o timer ao atingir zero
        }
    }, 1000);
}

window.onload = function () {
    var duration = 60 * 30; //Em segundos
    var duration_2 = 60 * 4; //Em segundos

    var display = document.querySelectorAll('.count p'); //Elemento para exibir
    var display_2 = document.querySelector('.count_2'); //Elemento para exibir

    for (let i = 0; i < display.length; i++) {
        startTimer(duration, display[i]);
    }

    startTimer(duration_2, display_2);
};

const setupTodayDate = () => {
    const today = new Date();
    const dateElement = document.querySelector('.top-strip b');

    if (!dateElement) return;

    dateElement.textContent = today.toLocaleDateString();
};

setupTodayDate();

function setupSwipers() {
    const swiperClients = new Swiper('.swiper-clients', {
        // Optional parameters
        direction: 'horizontal',

        // If we need pagination
        pagination: {
            el: '.swiper-pagination',
            clickable: true,
        },

        // autoplay: {
        //     delay: 4000,
        //     disableOnInteraction: false,
        //     pauseOnMouseEnter: true,
        // },

        spaceBetween: 10,
        centeredSlides: false,
        loop: true,
        slidesPerView: 6,

        breakpoints: {
            // when window width is >= 320px
            320: {
                slidesPerView: 'auto',
            },
            // when window width is >= 480px
            480: {
                slidesPerView: 'auto',
            },
            // when window width is >= 640px
            640: {
                slidesPerView: 4,
            },
            1440: {
                slidesPerView: 5,
            },
            1920: {
                slidesPerView: 6,
            },
        },

        // Navigation arrows
        navigation: {
            nextEl: '.swiper-button-next',
            prevEl: '.swiper-button-prev',
        },
    });

    const swiperBeforeAfter = new Swiper('.swiper-before-after', {
        // Optional parameters
        direction: 'horizontal',

        // If we need pagination
        pagination: {
            el: '.swiper-pagination',
            clickable: true,
        },

        spaceBetween: '30px',
        centeredSlides: false,
        loop: true,
        slidesPerView: 1,

        breakpoints: {
            // when window width is >= 480px
            676: {
                slidesPerView: 2,
            },
            // when window width is >= 640px
            992: {
                slidesPerView: 3,
            },
            1440: {
                slidesPerView: 4,
            },
            1920: {
                slidesPerView: 5,
            },
        },

        // Navigation arrows
        navigation: {
            nextEl: '.swiper-button-next',
            prevEl: '.swiper-button-prev',
        },
    });
}

setupSwipers();
